from ...libs.functions.common_ui_elements import collapsable
from ...addon.naming import FluidLabNaming
from ...libs.functions.animation import draw_anim_props


def blocks_anim(layout, toggles, props, type_props:str, target:str) -> None:

    if target == "linear_viscosity":
        collapsable_title = "Viscosity"
    elif target == "use_viscoelastic_springs":
        collapsable_title = "Viscoelastic"
    elif target == "fluid_radius":
        collapsable_title = "Interaction Radius"
    else:
        collapsable_title = target.title()

    timesteps_anim = collapsable(
        layout=layout,
        contain_prop=toggles,
        show_hide_str="fs_" + type_props + "_anim_" + target,
        mytext=collapsable_title.replace("_", " "),
        myicon='KEYINGSET',
        align=True,
    )
    if timesteps_anim:
        draw_anim_props(timesteps_anim, type_props, props, target, "fluidlab.fs_animation_button")


def animation_adv_ui(toggles, layout, main_col, anim_physics_props, anim_springs_props, anim_weights_props, anim_geometry_emitter_props) -> None:
    
    col = layout.column(align=True)
    # title_header(col, "Animation Settings")

    main_col = col.box().column(align=True)
    main_col.use_property_split = True
    main_col.use_property_decorate = False 
    
    # Emission:

    # TODO: por hacer el tema de las animaciones del initial velocity anim.
    
    # Object anim factor (Initial Velocity):
    # emission_anim = collapsable(
    #     main_col,
    #     toggles,
    #     "fs_emission_anim",
    #     "Emission",
    #     'PHYSICS',
    #     align=True,
    # )
    # if emission_anim:
    #     props = ["object_anim_factor_x", "object_anim_factor_y", "object_anim_factor_z"]
    #     for prop in props:
    #         blocks_anim(emission_anim, toggles, emit_emission_props, "emission", prop)
        
    # Physics:
    physics_anim = collapsable(
        main_col,
        toggles,
        "fs_physics_anim",
        "Physics",
        'PHYSICS',
        align=True,
    )
    if physics_anim:
        props = ["timestep", "subframes", "stiffness", "linear_viscosity", "fluid_radius"]
        for prop in props:
            blocks_anim(physics_anim, toggles, anim_physics_props, "physics", prop)
    
    # Springs:
    springs_anim = collapsable(
        main_col,
        toggles,
        "fs_springs_anim",
        "Springs",
        'GP_SELECT_STROKES',
        align=True,
    )
    if springs_anim:
        props = ["spring_force", "use_viscoelastic_springs"]
        for prop in props:
            blocks_anim(springs_anim, toggles, anim_springs_props, "springs", prop)

    # Weights:
    weights_anim = collapsable(
        main_col,
        toggles,
        "fs_weights_anim",
        "Weights",
        'FORCE_MAGNETIC',
        align=True,
    )
    if weights_anim:
        props = FluidLabNaming.weights
        for prop in props:
            blocks_anim(weights_anim, toggles, anim_weights_props, "weights", prop)
    
    # -------------------------------------------------------------------------------------------------------------------------
    # Excepcion Geometry Emitter / Geometry Switch:
    geometry_emitter_anim = collapsable(
        main_col,
        toggles,
        "fs_geometry_emitter_anim",
        "Geometry Emitter",
        'MONKEY',
        align=True,
    )
    if geometry_emitter_anim:
        props = anim_geometry_emitter_props # active_grpoup.geometry_emitter.x
        
        key_prop_name = "geometry_emitter"
        type_props = key_prop_name

        geometry_emitter_anim.prop(props, key_prop_name + "_switch", text="Switch at Frame")

        scale_x = 2.65
        scale_y = 1.3
        
        buttons = geometry_emitter_anim.grid_flow(row_major=True, columns=3, even_columns=False, even_rows=False, align=True)
        animed = getattr(props, key_prop_name + "_animed")
        if not animed:
            buttons.label(text="")
            bt_add = buttons.row(align=True)
            bt_add.scale_y = scale_y
            bt_add.scale_x = scale_x
            bt_add.operator("fluidlab.fs_animation_button", text="Add", icon='KEY_HLT').call_from = "Add" + "." + type_props + "." + key_prop_name
        else:
            scale_x = 2.374
            buttons.label(text="")
            bt_remove = buttons.row(align=True)
            bt_remove.scale_y = scale_y
            bt_remove.scale_x = scale_x
            bt_remove.alert = True
            bt_remove.operator("fluidlab.fs_animation_button", text="Remove", icon='KEY_DEHLT').call_from = "Remove" + "." + type_props + "." + key_prop_name